ORCA/M Asm65816 2.1.0

0001 0000              ****************************************************************
0002 0000              *
0003 0000              * TLTable
0004 0000              *
0005 0000              * This is the Function pointer Table (FPT) for the tool
0006 0000              * locator tool set.
0007 0000              *
0008 0000              * Note:  Functions marked with "[ts]" are already patched for
0009 0000              *        us in Tool.Setup.
0010 0000              *
0011 0000              ****************************************************************
0012 0000              LocatorCallTable proc EXPORT 
0013 0000
0014 0000                       IMPORT TLBootInit 
0015 0000                       IMPORT TLVersion 
0016 0000              ;	import AcceptRequests	;17-Sep-90 DAL
0017 0000              ;	import SendRequest	;17-Sep-90 DAL
0018 0000              ;	import GetMsgHandle	;25-Sep-90 DAL
0019 0000              ;	import StartUpTools	;17-Nov-90 DAL
0020 0000              ;	import ShutDownTools	;17-Nov-90 DAL
0021 0000              ;	import LoadOneTool	;17-Nov-90 DAL
0022 0000              ;	import LoadTools	;17-Nov-90 DAL
0023 0000              ;	import UnloadOneTool	;25-Nov-90 DAL
0024 0000                       import TLShutDown              ;6-Jun-91 DAL
0025 0000                       import SaveTextState           ;6-Jun-91 DAL
0026 0000                       import RestoreTextState        ;6-Jun-91 DAL
0027 0000                       import MessageCenter           ;2-Dec-91 DAL
0028 0000
0029 0000              TheBeginning  
0030 0000 1D 00 00 00           DC L:(TheEnd-TheBeginning)/4   ; call count + 1
0031 0004
0032 0004 78 03 02 00           DC L:TLBootInit-1              ; TLBootInit (0101)
0033 0008 00 00 00 00           DC L:0                         ; TLStartUp  (0201)
0034 000C 21 04 02 00           DC L:TLShutDown-1              ; TLShutDwon (0301)
0035 0010 73 03 02 00           DC L:TLVersion-1               ; TLVersion  (0401)
0036 0014 00 00 00 00           DC L:0                         ; TLReset    (0501)
0037 0018 00 00 00 00           DC L:0                         ; TLStatus   (0601)
0038 001C 00 00 00 00           DC L:0                         ; NotImp     (0701)
0039 0020 00 00 00 00           DC L:0                         ; NotImp     (0801)
0040 0024 00 00 00 00           DC L:0                         ; GetTSPtr   (0901)
0041 0028 00 00 00 00           DC L:0                         ; SetTSPtr   (0A01)
0042 002C 00 00 00 00           DC L:0                         ; GetFuncPtr (0B01)
0043 0030 00 00 00 00           DC L:0                         ; GetWAP     (0C01)
0044 0034 00 00 00 00           DC L:0                         ; SetWAP     (0D01)
0045 0038 00 00 00 00           DC L:0                         ;[ts] LoadTools-1	; 0e01
0046 003C 00 00 00 00           DC L:0                         ;[ts] LoadOneTool-1	   ; 0f01
0047 0040 00 00 00 00           DC L:0                         ;[ts] UnloadOneTool-1  ; 1001
0048 0044 00 00 00 00           DC L:0                         ; TLMountVolume     1101
0049 0048 00 00 00 00           DC L:0                         ; TLTextMountVolume 1201
0050 004C 7D 03 02 00           DC L:SaveTextState-1           ; SaveTextState     1301
0051 0050 C8 03 02 00           DC L:RestoreTextState-1        ; RestoreTextState  1401
0052 0054 02 04 02 00           DC L:MessageCenter-1           ; MessageCenter     1501 patched 2-Dec-91 DAL
0053 0058 00 00 00 00           DC L:0                         ; SetDefaultTPT     1601
0054 005C 00 00 00 00           DC L:0                         ; MessageByName     1701
0055 0060 00 00 00 00           DC L:0                         ;[ts] StartupTools-1    ; StartUpTools      1801
0056 0064 00 00 00 00           DC L:0                         ;[ts] ShutDownTools-1   ; ShutDownTools     1901
0057 0068              *** New calls for 6.0
0058 0068 00 00 00 00           DC L:0                         ;[ts] GetMsgHandle-1    ; 1A01  17-Sep-90 DAL
0059 006C 00 00 00 00           DC L:0                         ;[ts] AcceptRequests-1  ; 1B01  17-Sep-90 DAL
0060 0070 00 00 00 00           DC L:0                         ;[ts] SendRequest-1	    ; 1C01  17-Sep-90 DAL
0061 0074              TheEnd    
0062 0074                       EndP 
0063 0074
0064 0074
0065 0074              ****************************************************************
0066 0074              *
0067 0074              * ROM 3 patch for TLVersion
0068 0074              *
0069 0074              ****************************************************************
0070 0074              TLVersion proc export 
0071 0074                       export TLBootInit 
0072 0074
0073 0074 A9 02 03              lda   #LocatorVersion
0074 0077 83 07                 sta   7,s
0075 0079              *
0076 0079              * This null routine is called when the patch is installed.
0077 0079              * it should never be called again.
0078 0079              *
0079 0079              TLBootInit  
0080 0079
0081 0079 A9 00 00     oEndCall0 lda   #0
0082 007C 18                    clc   
0083 007D 6B                    rtl   
0084 007E
0085 007E                       EndP 
0086 007E
0087 007E
0088 007E              ****************************************************************
0089 007E              *
0090 007E              * SaveTextState -- new patch 6-Jun-91 DAL
0091 007E              *
0092 007E              * Call the ROM 3 SaveTextState code, and then stuff the text
0093 007E              * shadow bit into bit 0 of offset 1 in the resulting record,
0094 007E              * and enable text shadowing.
0095 007E              *
0096 007E              ****************************************************************
0097 007E              SaveTextState proc 
0098 007E
0099 007E 48                    pha   
0100 007F 48                    pha   
0101 0080 22 C4 03 02           jsl   ToROM
0102 0084 AA                    tax                            ;keep error code
0103 0085 A3 03                 lda   3,s
0104 0087 83 0D                 sta   9+4,s
0105 0089 A3 01                 lda   1,s
0106 008B 83 0B                 sta   7+4,s
0107 008D
0108 008D A3 02                 lda   2,s
0109 008F F0 22                 beq   @exit
0110 0091
0111 0091 DA                    phx                            ;save error
0112 0092 0B                    phd   
0113 0093 3B                    tsc   
0114 0094 5B                    tcd   
0115 0095 A0 02 00              ldy   #2
0116 0098 B7 05                 lda   [5],y
0117 009A AA                    tax   
0118 009B A7 05                 lda   [5]
0119 009D 85 05                 sta   5
0120 009F 86 07                 stx   7                        ;dereferenced result
0121 00A1
0122 00A1 AF 35 C0 E0           lda   >$e0c035
0123 00A5 4A                    lsr   a                        ;text state in Carry
0124 00A6 08                    php   
0125 00A7 A0 01 00              ldy   #1
0126 00AA B7 05                 lda   [5],y                    ;get old value from record, strip bit 0
0127 00AC 4A                    lsr   a
0128 00AD 28                    plp                            ;get text state back in Carry
0129 00AE 2A                    rol   a                        ;put text state into bit 0
0130 00AF 97 05                 sta   [5],y
0131 00B1
0132 00B1 2B                    pld   
0133 00B2 FA                    plx                            ;restore error code
0134 00B3
0135 00B3 68           @exit    pla   
0136 00B4 68                    pla                            ;pop my temp result space
0137 00B5
0138 00B5 AF 35 C0 E0           lda   >$e0c035
0139 00B9 4A                    lsr   a
0140 00BA 0A                    asl   a                        ;clear bit 0 = enable text shadowing
0141 00BB 8F 35 C0 E0           sta   >$e0c035
0142 00BF
0143 00BF 8A                    txa   
0144 00C0 C9 01 00              cmp   #1
0145 00C3 6B                    rtl   
0146 00C4
0147 00C4 22 D6 C8 FD  ToROM    jsl   $fdc8d6
0148 00C8 6B                    rtl   
0149 00C9
0150 00C9                       EndP 
0151 00C9
0152 00C9
0153 00C9              ****************************************************************
0154 00C9              *
0155 00C9              * RestoreTextState -- new patch 6-Jun-91 DAL
0156 00C9              *
0157 00C9              * Check for a NIL state handle; do nothing if NIL.
0158 00C9              *
0159 00C9              * Set text shadowing bit from bit 0 of offset 1 in the state
0160 00C9              * handle.
0161 00C9              *
0162 00C9              ****************************************************************
0163 00C9              RestoreTextState proc 
0164 00C9
0165 00C9 A3 08                 lda   8,s                      ;check middle word of handle
0166 00CB F0 2C                 beq   @nil
0167 00CD
0168 00CD 0B                    phd   
0169 00CE A3 0B                 lda   11,s
0170 00D0 48                    pha   
0171 00D1 A3 0B                 lda   11,s
0172 00D3 48                    pha   
0173 00D4 3B                    tsc   
0174 00D5 5B                    tcd   
0175 00D6
0176 00D6 A0 02 00              ldy   #2
0177 00D9 B7 01                 lda   [1],y
0178 00DB AA                    tax   
0179 00DC A7 01                 lda   [1]
0180 00DE 85 01                 sta   1
0181 00E0 86 03                 stx   3
0182 00E2 88                    dey                            ;Y=1 = offset into state record
0183 00E3 B7 01                 lda   [1],y
0184 00E5 4A                    lsr   a                        ;text state in Carry
0185 00E6 08                    php   
0186 00E7 AF 35 C0 E0           lda   >$e0c035
0187 00EB 4A                    lsr   a
0188 00EC 28                    plp                            ;text state back in Carry
0189 00ED 2A                    rol   a
0190 00EE 8F 35 C0 E0           sta   >$e0c035
0191 00F2
0192 00F2 68                    pla   
0193 00F3 68                    pla   
0194 00F4 2B                    pld   
0195 00F5
0196 00F5 5C 4C CA FD           jml   >$fdca4c                 ;RestoreTextState in ROM
0197 00F9
0198 00F9 A2 00 00     @nil     ldx   #0
0199 00FC A0 04 00              ldy   #4
0200 00FF 5C 84 01 E1           jml   $e10184                  ;ToStrip
0201 0103
0202 0103                       EndP 
0203 0103
0204 0103
0205 0103              ****************************************************************
0206 0103              *
0207 0103              * MessageCenter -- new patch 2-Dec-91 DAL
0208 0103              *
0209 0103              * When deleting message 1, also automatically delete message $0011.
0210 0103              *
0211 0103              ****************************************************************
0212 0103              MessageCenter proc 
0213 0103
0214 0103              sTheHandle equ   7                      ;offsets into stack
0215 0103              sTheType equ   sTheHandle+4
0216 0103              sTheAction equ   sTheType+2
0217 0103
0218 0103 A3 0D                 lda   sTheAction,s
0219 0105 C9 03 00              cmp   #3                       ;delete
0220 0108 D0 14                 bne   @notKludge
0221 010A A3 0B                 lda   sTheType,s
0222 010C 3A                    dec   a
0223 010D D0 0F                 bne   @notKludge
0224 010F
0225 010F F4 03 00              pea   3                        ;action=delete
0226 0112 F4 11 00              pea   $0011                    ;message = new Types msg
0227 0115 DA                    phx   
0228 0116 DA                    phx                            ;handle = ignored
0229 0117 A2 01 15 22           _MessageCenter 
0230 011E
0231 011E 5C 3E C1 FD  @notKludge jml   >$fdc13e               ;MessageCenter in ROM 3
0232 0122              *** end 2-Dec-91
0233 0122
0234 0122
0235 0122              ****************************************************************
0236 0122              *
0237 0122              * TLShutDown -- new patch 6-Jun-91 DAL
0238 0122              *
0239 0122              * In case the stoopid application left SANE started up, we'll
0240 0122              * shut it down for them.  This avoids, say, an NDA seeing that
0241 0122              * SANE is still started & using it, when it's actually using
0242 0122              * some memory that is no longer allocated (ouch!).
0243 0122              *
0244 0122              ****************************************************************
0245 0122              TLShutDown proc export 
0246 0122
0247 0122 A2 12 03 22           _QDAuxShutDown                 ;added 14-Sep-91 DAL
0248 0129
0249 0129 A2 0A 03 22           _SANEShutDown 
0250 0130 5C 42 03 FE           jml   >$fe0342                 ;original ROM 3 TLShutDown
0251 0134
0252 0134                       EndP 
